/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.user;

import com.ibm.hwmca.base.settings.user.UserSettingsBean;
import com.ibm.hwmca.fw.settings.user.BonsaiUserSettings;
import com.ibm.hwmca.fw.settings.user.UserSettings;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.UserTaskManager;

public class ToggleViewsBean
extends UserSettingsBean {
    private boolean showBanner;
    private boolean showActiveTasks;
    private boolean showTasksView;
    private BonsaiUserSettings settings;
    private BonsaiUserSettings savedSettings;
    private static final String TRACEMASK_T = "XPTRTVBT";
    private static final String TRACEMASK_F = "XPTRTVBF";
    private static final String TRACEMASK_D = "XPTRTVBD";

    public void setShowBanner(boolean showBanner) {
        this.showBanner = showBanner;
        this.settings.setShowBanner(showBanner);
    }

    public boolean isShowBanner() {
        return this.showBanner;
    }

    public void setShowActiveTasks(boolean showActiveTasks) {
        this.showActiveTasks = showActiveTasks;
        this.settings.setShowActiveTasks(showActiveTasks);
    }

    public boolean isShowActiveTasks() {
        return this.showActiveTasks;
    }

    public void setShowTasksView(boolean showTasksView) {
        this.showTasksView = showTasksView;
        this.settings.setShowTasksView(showTasksView);
    }

    public boolean isShowTasksView() {
        return this.showTasksView;
    }

    public void load() {
        Trace.trace(TRACEMASK_F, "--> ToggleViewsBean.load()");
        if (this.settings != null) {
            this.init();
            this.savedSettings = (BonsaiUserSettings)this.settings.clone();
        }
        Trace.trace(TRACEMASK_F, "<-- ToggleViewsBean.load()");
    }

    private void init() {
        if (this.settings != null) {
            this.showBanner = this.settings.isShowBanner();
            this.showActiveTasks = this.settings.isShowActiveTasks();
            this.showTasksView = this.settings.isShowTasksView();
        }
    }

    public void setUserSettings(BonsaiUserSettings settings) {
        this.settings = settings;
    }

    protected UserSettings getUserSettings() {
        return this.settings;
    }

    protected boolean hasSettingsChanged() {
        Trace.trace(TRACEMASK_F, "-> ToggleViewsBean.hasSettingsChanged()");
        boolean settingsChanged = false;
        if (this.settings != null) {
            this.getUserTaskManager().storeAllElements();
            settingsChanged = !this.settings.equals(this.savedSettings);
        }
        Trace.trace(TRACEMASK_F, "<- ToggleViewsBean.hasSettingsChanged() result: " + settingsChanged);
        return settingsChanged;
    }

    protected void resetUserSettings(UserTaskManager utm) {
        Trace.trace(TRACEMASK_F, "<-> ToggleViewsBean.resetUserSettings(" + utm + ")");
        this.settings = (BonsaiUserSettings)this.savedSettings.clone();
        this.init();
    }

    public void update(Object obj) {
        Trace.trace(TRACEMASK_F, "<--> ToggleViewsBean.update(" + obj + ")");
        this.setUserSettings((BonsaiUserSettings)obj);
        this.init();
    }

    protected void updateUserSettings() {
        Trace.trace(TRACEMASK_F, "<-> ToggleViewsBean.updateUserSettings()");
        if (this.settings != null) {
            this.savedSettings = (BonsaiUserSettings)this.settings.clone();
        }
    }
}

